proc tabulate missing noseps data = ghpb08;
TITLE 'Table A8.  Number of Health Plans and Total Participants';
TITLE2 'by collective bargaining status, type of insurance, and plan, 2008';
CLASS COLLECTIVE_BARGAIN_IND INS3 ENT2 filingsize;                                                                                                                                                                     
FORMAT COLLECTIVE_BARGAIN_IND $CB2F. ENT2 $ENT2F. INS3 INS3F.;
                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                            
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_cnt; 
TABLE all='Total Plans' filingsize=' ',
	  (ALL COLLECTIVE_BARGAIN_IND='')*(ALL ENT2=' '),                                                                                                                                                                   
      (ALL='Total Plans' INS3=' ')*                                                                                                                                                                    
      (N='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNT*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  
